/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import org.joml.Math;

public class SlashBladeState
implements ISlashBladeState {
    protected long lastActionTime;
    protected int targetEntityId;
    protected boolean _onClick;
    protected float fallDecreaseRate;
    protected boolean isCharged;
    protected float attackAmplifier;
    protected ResourceLocation comboSeq;
    protected String lastPosHash;
    protected boolean isBroken;
    protected boolean isNoScabbard;
    protected boolean isSealed;
    protected float baseAttackModifier = 4.0f;
    protected int killCount;
    protected int refine;
    protected UUID owner;
    protected UUID uniqueId = UUID.randomUUID();
    protected String translationKey = "";
    protected ResourceLocation slashArtsKey;
    protected boolean isDefaultBewitched = false;
    protected ResourceLocation comboRootName;
    protected Optional<CarryType> carryType = Optional.empty();
    protected Optional<Color> effectColor = Optional.empty();
    protected boolean effectColorInverse;
    protected Optional<Vec3> adjust = Optional.empty();
    protected Optional<ResourceLocation> texture = Optional.empty();
    protected Optional<ResourceLocation> model = Optional.empty();
    protected LazyOptional<ResourceLocation> rootCombo = this.instantiateRootComboHolder();
    protected int maxDamage = 40;
    protected int damage = 0;
    protected int proudSoul = 0;
    protected boolean isChangedActiveState = false;
    protected List<ResourceLocation> specialEffects = new ArrayList<ResourceLocation>();

    public SlashBladeState(ItemStack blade) {
        if (!blade.m_41619_() && blade.m_41784_().m_128441_("bladeState")) {
            this.deserializeNBT(blade.m_41737_("bladeState"));
        }
    }

    @Override
    public long getLastActionTime() {
        return this.lastActionTime;
    }

    @Override
    public void setLastActionTime(long lastActionTime) {
        this.lastActionTime = lastActionTime;
        this.setHasChangedActiveState(true);
    }

    @Override
    public boolean onClick() {
        return this._onClick;
    }

    @Override
    public void setOnClick(boolean onClick) {
        this._onClick = onClick;
        this.setHasChangedActiveState(true);
    }

    @Override
    public float getFallDecreaseRate() {
        return this.fallDecreaseRate;
    }

    @Override
    public void setFallDecreaseRate(float fallDecreaseRate) {
        this.fallDecreaseRate = fallDecreaseRate;
        this.setHasChangedActiveState(true);
    }

    @Override
    public float getAttackAmplifier() {
        return this.attackAmplifier;
    }

    @Override
    public void setAttackAmplifier(float attackAmplifier) {
        this.attackAmplifier = attackAmplifier;
        this.setHasChangedActiveState(true);
    }

    @Override
    @Nonnull
    public ResourceLocation getComboSeq() {
        return this.comboSeq != null ? this.comboSeq : ComboStateRegistry.NONE.getId();
    }

    @Override
    public void setComboSeq(ResourceLocation comboSeq) {
        this.comboSeq = comboSeq;
        this.setHasChangedActiveState(true);
    }

    @Override
    public boolean isBroken() {
        return this.isBroken;
    }

    @Override
    public void setBroken(boolean broken) {
        this.isBroken = broken;
        this.setHasChangedActiveState(true);
    }

    @Override
    public boolean isSealed() {
        return this.isSealed;
    }

    @Override
    public void setSealed(boolean sealed) {
        this.isSealed = sealed;
    }

    @Override
    public float getBaseAttackModifier() {
        return this.baseAttackModifier;
    }

    @Override
    public void setBaseAttackModifier(float baseAttackModifier) {
        this.baseAttackModifier = baseAttackModifier;
    }

    @Override
    public int getKillCount() {
        return this.killCount;
    }

    @Override
    public void setKillCount(int killCount) {
        this.killCount = killCount;
        this.setHasChangedActiveState(true);
    }

    @Override
    public int getRefine() {
        return this.refine;
    }

    @Override
    public void setRefine(int refine) {
        this.refine = refine;
        this.setHasChangedActiveState(true);
    }

    @Override
    public ResourceLocation getSlashArtsKey() {
        return this.slashArtsKey;
    }

    @Override
    public void setSlashArtsKey(ResourceLocation key) {
        this.slashArtsKey = key;
    }

    @Override
    public boolean isDefaultBewitched() {
        return this.isDefaultBewitched;
    }

    @Override
    public void setDefaultBewitched(boolean defaultBewitched) {
        this.isDefaultBewitched = defaultBewitched;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public void setTranslationKey(String translationKey) {
        this.translationKey = Optional.ofNullable(translationKey).orElse("");
    }

    @Override
    @Nonnull
    public CarryType getCarryType() {
        return this.carryType.orElse(CarryType.NONE);
    }

    @Override
    public void setCarryType(CarryType carryType) {
        this.carryType = Optional.ofNullable(carryType);
    }

    @Override
    public Color getEffectColor() {
        return this.effectColor.orElseGet(() -> new Color(0x3333FF));
    }

    @Override
    public void setEffectColor(Color effectColor) {
        this.effectColor = Optional.ofNullable(effectColor);
    }

    @Override
    public boolean isEffectColorInverse() {
        return this.effectColorInverse;
    }

    @Override
    public void setEffectColorInverse(boolean effectColorInverse) {
        this.effectColorInverse = effectColorInverse;
    }

    @Override
    public Vec3 getAdjust() {
        return this.adjust.orElseGet(() -> Vec3.f_82478_);
    }

    @Override
    public void setAdjust(Vec3 adjust) {
        this.adjust = Optional.ofNullable(adjust);
    }

    @Override
    public Optional<ResourceLocation> getTexture() {
        return this.texture;
    }

    @Override
    public void setTexture(ResourceLocation texture) {
        this.texture = Optional.ofNullable(texture);
    }

    @Override
    public Optional<ResourceLocation> getModel() {
        return this.model;
    }

    @Override
    public void setModel(ResourceLocation model) {
        this.model = Optional.ofNullable(model);
    }

    @Override
    public int getTargetEntityId() {
        return this.targetEntityId;
    }

    @Override
    public void setTargetEntityId(int id) {
        this.targetEntityId = id;
        this.setHasChangedActiveState(true);
    }

    @Override
    public ResourceLocation getComboRoot() {
        if (this.comboRootName == null || !ComboStateRegistry.REGISTRY.get().containsKey(this.comboRootName)) {
            return ComboStateRegistry.STANDBY.getId();
        }
        return this.comboRootName;
    }

    @Override
    public void setComboRoot(ResourceLocation rootLoc) {
        this.comboRootName = ComboStateRegistry.REGISTRY.get().containsKey(rootLoc) ? rootLoc : ComboStateRegistry.STANDBY.getId();
        this.rootCombo = this.instantiateRootComboHolder();
    }

    private LazyOptional<ResourceLocation> instantiateRootComboHolder() {
        return LazyOptional.of(() -> {
            if (!ComboStateRegistry.REGISTRY.get().containsKey(this.getComboRoot())) {
                return ComboStateRegistry.STANDBY.getId();
            }
            return this.getComboRoot();
        });
    }

    @Override
    public boolean hasChangedActiveState() {
        return this.isChangedActiveState;
    }

    @Override
    public void setHasChangedActiveState(boolean isChanged) {
        this.isChangedActiveState = isChanged;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Override
    public int getMaxDamage() {
        return this.maxDamage;
    }

    @Override
    public void setMaxDamage(int damage) {
        this.maxDamage = damage;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public void setDamage(int damage) {
        this.damage = Math.max((int)0, (int)damage);
        this.setHasChangedActiveState(true);
    }

    @Override
    public int getProudSoulCount() {
        return this.proudSoul;
    }

    @Override
    public void setProudSoulCount(int psCount) {
        this.proudSoul = Math.max((int)0, (int)psCount);
        this.setHasChangedActiveState(true);
    }

    @Override
    public List<ResourceLocation> getSpecialEffects() {
        return this.specialEffects;
    }

    @Override
    public void setSpecialEffects(ListTag list) {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        list.forEach(tag -> {
            ResourceLocation se = ResourceLocation.m_135820_((String)tag.m_7916_());
            if (SpecialEffectsRegistry.REGISTRY.get().containsKey(se)) {
                result.add(se);
            }
        });
        this.specialEffects = result;
    }

    @Override
    public boolean addSpecialEffect(ResourceLocation se) {
        if (SpecialEffectsRegistry.REGISTRY.get().containsKey(se)) {
            return this.specialEffects.add(se);
        }
        return false;
    }

    @Override
    public boolean removeSpecialEffect(ResourceLocation se) {
        return this.specialEffects.remove(se);
    }

    @Override
    public boolean hasSpecialEffect(ResourceLocation se) {
        if (SpecialEffectsRegistry.REGISTRY.get().containsKey(se)) {
            return this.specialEffects.contains(se);
        }
        this.specialEffects.remove(se);
        return true;
    }
}

